/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#if defined (_WIN32)
#if _MULTI_THREADING_SUPPORT
#include <windows.h>
#else
//#include <stdlib.h>
#endif
#define NO_DRM_CRT 1
#include <drmcommon.h>
#include <oemimpl.h>


/* ============================================================================ */
DRM_VOID DRM_API 
OEM_InitializeCriticalSection(
    IN OUT OEM_CRITICAL_SECTION *pCS)
{
#if _MULTI_THREADING_SUPPORT==1
    CRITICAL_SECTION *poCS=(CRITICAL_SECTION *)pCS;
    DRMSIZEASSERT(SIZEOF(OEM_CRITICAL_SECTION), SIZEOF(CRITICAL_SECTION));
    InitializeCriticalSection(poCS);
#endif
}


/* ============================================================================ */
DRM_VOID DRM_API 
OEM_DeleteCriticalSection(
    IN OUT OEM_CRITICAL_SECTION *pCS)
{
#if _MULTI_THREADING_SUPPORT==1
    CRITICAL_SECTION *poCS=(CRITICAL_SECTION *)pCS;
    DRMSIZEASSERT(SIZEOF(OEM_CRITICAL_SECTION), SIZEOF(CRITICAL_SECTION));
    DeleteCriticalSection(poCS);

    ZEROMEM(poCS, SIZEOF(CRITICAL_SECTION));
#endif
}
    

/* ============================================================================ */
DRM_VOID DRM_API 
OEM_EnterCriticalSection(
    IN OUT OEM_CRITICAL_SECTION *pCS)
{
#if _MULTI_THREADING_SUPPORT==1
    CRITICAL_SECTION *poCS=(CRITICAL_SECTION *)pCS;
    DRMSIZEASSERT(SIZEOF(OEM_CRITICAL_SECTION), SIZEOF(CRITICAL_SECTION));
    EnterCriticalSection(poCS);
#endif
}


/* ============================================================================ */
DRM_VOID DRM_API 
OEM_LeaveCriticalSection(
    IN OUT OEM_CRITICAL_SECTION *pCS)
{
#if _MULTI_THREADING_SUPPORT==1
    CRITICAL_SECTION *poCS=(CRITICAL_SECTION *)pCS;
    DRMSIZEASSERT(SIZEOF(OEM_CRITICAL_SECTION), SIZEOF(CRITICAL_SECTION));
    LeaveCriticalSection(poCS);
#endif
}

#endif   /* (_WIN32) */


